import React from 'react';
import styles from './UserMenu.scss.js';
import { MessageIndicator } from '../../../MessageIndicator/MessageIndicator.js';
import { Menu } from '../Menu/Menu.js';
import { Avatar } from '../../../Avatar/Avatar.js';

function UserMenu({
  name,
  detail,
  avatar,
  initials,
  actions,
  message,
  onToggle,
  open,
  colorScheme,
  accessibilityLabel
}) {
  const showIndicator = Boolean(message);
  const activatorContentMarkup = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(MessageIndicator, {
    active: showIndicator
  }, /*#__PURE__*/React.createElement(Avatar, {
    size: "small",
    source: avatar,
    initials: initials && initials.replace(' ', '')
  })), /*#__PURE__*/React.createElement("span", {
    className: styles.Details
  }, /*#__PURE__*/React.createElement("p", {
    className: styles.Name
  }, name), /*#__PURE__*/React.createElement("p", {
    className: styles.Detail
  }, detail)));

  if (colorScheme && process.env.NODE_ENV === 'development') {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: The `colorScheme` prop on the `UserMenu` component has been deprecated. See the v10 migration guide for replacing dark color scheme styles. https://github.com/Shopify/polaris/blob/main/documentation/guides/migrating-from-v9-to-v10.md');
  }

  return /*#__PURE__*/React.createElement(Menu, {
    activatorContent: activatorContentMarkup,
    open: open,
    onOpen: onToggle,
    onClose: onToggle,
    actions: actions,
    message: message,
    colorScheme: colorScheme,
    accessibilityLabel: accessibilityLabel
  });
}

export { UserMenu };
