import React, { useRef } from 'react';
import { useComponentDidMount } from '../../../../utilities/use-component-did-mount.js';
import styles from '../../BulkActions.scss.js';
import { Indicator } from '../../../Indicator/Indicator.js';
import { Button } from '../../../Button/Button.js';

function BulkActionButton({
  handleMeasurement,
  url,
  external,
  onAction,
  content,
  disclosure,
  accessibilityLabel,
  disabled,
  indicator
}) {
  const bulkActionButton = useRef(null);
  useComponentDidMount(() => {
    if (handleMeasurement && bulkActionButton.current) {
      const width = bulkActionButton.current.getBoundingClientRect().width;
      handleMeasurement(width);
    }
  });
  return /*#__PURE__*/React.createElement("div", {
    className: styles.BulkActionButton,
    ref: bulkActionButton
  }, /*#__PURE__*/React.createElement(Button, {
    external: external,
    url: url,
    "aria-label": accessibilityLabel,
    onClick: onAction,
    disabled: disabled,
    disclosure: disclosure
  }, content), indicator && /*#__PURE__*/React.createElement(Indicator, null));
}

export { BulkActionButton };
