/**
 * Values to convert to CSS custom properties.
 * @example {background: '#000'} // --p-background: #000;
 */
export interface TokenProperties {
    description?: string;
    value: string;
}
export interface TokenGroup {
    [token: string]: TokenProperties;
}
export declare type ColorScheme = 'light' | 'dark';
/**
 * Mapping of Polaris color schemes to operating system color schemes.
 *
 * Note: The associated OS value will be set for the CSS `color-scheme` declaration.
 * https://developer.mozilla.org/en-US/docs/Web/CSS/color-scheme
 */
export declare type OSColorSchemes = {
    [C in ColorScheme]: 'light' | 'dark' | 'normal';
};
export declare const osColorSchemes: OSColorSchemes;
/**
 * Polaris color schemes and their associated color tokens.
 */
export declare type ColorSchemes = {
    [C in ColorScheme]: TokenGroup;
};
export interface Tokens {
    breakpoints: TokenGroup;
    colorSchemes: ColorSchemes;
    depth: TokenGroup;
    legacyTokens: TokenGroup;
    motion: TokenGroup;
    shape: TokenGroup;
    spacing: TokenGroup;
    typography: TokenGroup;
    zIndex: TokenGroup;
}
export declare const tokens: {
    breakpoints: {
        'breakpoints-xs': {
            value: string;
        };
        'breakpoints-sm': {
            value: string;
        };
        'breakpoints-md': {
            value: string;
        };
        'breakpoints-lg': {
            value: string;
        };
        'breakpoints-xl': {
            value: string;
        };
    };
    colorSchemes: ColorSchemes;
    depth: {
        'shadow-transparent': {
            value: string;
        };
        'shadow-faint': {
            value: string;
        };
        'shadow-base': {
            value: string;
        };
        'shadow-deep': {
            value: string;
        };
        'shadow-button': {
            value: string;
        };
        'shadow-top-bar': {
            value: string;
        };
        'shadow-card': {
            value: string;
        }; /**
         * Values to convert to CSS custom properties.
         * @example {background: '#000'} // --p-background: #000;
         */
        'shadow-popover': {
            value: string;
        };
        'shadow-layer': {
            value: string;
        };
        'shadow-modal': {
            value: string;
        };
        'shadows-inset-button': {
            value: string;
        };
        'shadows-inset-button-pressed': {
            value: string;
        };
    };
    legacyTokens: {
        'override-loading-z-index': {
            value: string;
        };
        'choice-size': {
            value: string;
        };
        'icon-size-small': {
            value: string;
        };
        'icon-size-medium': {
            value: string;
        };
        'choice-margin': {
            value: string;
        };
        'control-border-width': {
            value: string;
        };
        'banner-border-default': {
            value: string;
        };
        'banner-border-success': {
            value: string;
        };
        'banner-border-highlight': {
            value: string;
        };
        'banner-border-warning': {
            value: string;
        };
        'banner-border-critical': {
            value: string;
        };
        'thin-border-subdued': {
            value: string;
        };
        'text-field-spinner-offset': {
            value: string;
        };
        'text-field-focus-ring-offset': {
            value: string;
        };
        'button-group-item-spacing': {
            value: string;
        };
        /**
         * Polaris color schemes and their associated color tokens.
         */
        'range-slider-thumb-size-base': {
            value: string;
        };
        'range-slider-thumb-size-active': {
            value: string;
        };
        'frame-offset': {
            value: string;
        };
    };
    motion: {
        'duration-0': {
            value: string;
        };
        'duration-50': {
            value: string;
        };
        'duration-100': {
            value: string;
        };
        'duration-150': {
            value: string;
        };
        'duration-200': {
            value: string;
        };
        'duration-250': {
            value: string;
        };
        'duration-300': {
            value: string;
        };
        'duration-350': {
            value: string;
        };
        'duration-400': {
            value: string;
        };
        'duration-450': {
            value: string;
        };
        'duration-500': {
            value: string;
        };
        'duration-5000': {
            value: string;
        };
        ease: {
            value: string;
        };
        'ease-in': {
            value: string;
        };
        'ease-out': {
            value: string;
        };
        'ease-in-out': {
            value: string;
        };
        linear: {
            value: string;
        };
        'keyframes-bounce': {
            value: string;
        };
        'keyframes-fade-in': {
            value: string;
        };
        'keyframes-pulse': {
            value: string;
        };
        'keyframes-spin': {
            value: string;
        };
    };
    shape: {
        'border-radius-05': {
            value: string;
        };
        'border-radius-1': {
            value: string;
        };
        'border-radius-2': {
            value: string;
        };
        'border-radius-3': {
            value: string;
        };
        'border-radius-4': {
            value: string;
        };
        'border-radius-5': {
            value: string;
        };
        'border-radius-6': {
            value: string;
        };
        'border-radius-base': {
            value: string;
        };
        'border-radius-large': {
            value: string;
        };
        'border-radius-half': {
            value: string;
        };
        'border-width-1': {
            value: string;
        };
        'border-width-2': {
            value: string;
        };
        'border-width-3': {
            value: string;
        };
        'border-width-4': {
            value: string;
        };
        'border-width-5': {
            value: string;
        };
        'border-base': {
            value: string;
        };
        'border-dark': {
            value: string;
        };
        'border-transparent': {
            /**
             * Mapping of Polaris color schemes to operating system color schemes.
             *
             * Note: The associated OS value will be set for the CSS `color-scheme` declaration.
             * https://developer.mozilla.org/en-US/docs/Web/CSS/color-scheme
             */
            value: string;
        };
        'border-divider': {
            value: string;
        };
        'border-divider-on-dark': {
            value: string;
        };
    };
    spacing: {
        'space-0': {
            value: string;
        };
        'space-025': {
            value: string;
        };
        'space-05': {
            value: string;
        };
        'space-1': {
            value: string;
        };
        'space-2': {
            value: string;
        };
        'space-3': {
            value: string;
        };
        'space-4': {
            value: string;
        };
        'space-5': {
            value: string;
        };
        'space-6': {
            value: string;
        };
        'space-8': {
            value: string;
        };
        'space-10': {
            value: string;
        };
        'space-12': {
            value: string;
        };
        'space-16': {
            value: string;
        };
        'space-20': {
            value: string;
        };
        'space-24': {
            value: string;
        };
        'space-28': {
            value: string;
        };
        'space-32': {
            value: string;
        };
    };
    typography: {
        'font-family-sans': {
            value: string;
        };
        'font-family-mono': {
            value: string;
        };
        'font-size-1': {
            value: string;
        };
        'font-size-2': {
            value: string;
        };
        'font-size-3': {
            value: string;
        };
        'font-size-4': {
            value: string;
        };
        'font-size-5': {
            value: string;
        };
        'font-size-6': {
            value: string;
        };
        'font-size-7': {
            value: string;
        };
        'font-size-8': {
            value: string;
        };
        'font-size-9': {
            value: string;
        };
        'font-size-10': {
            value: string;
        };
        'font-size-11': {
            value: string;
        };
        'font-size-12': {
            value: string;
        };
        'font-size-13': {
            value: string;
        };
        'font-weight-regular': {
            value: string;
        }; /**
         * Mapping of Polaris color schemes to operating system color schemes.
         *
         * Note: The associated OS value will be set for the CSS `color-scheme` declaration.
         * https://developer.mozilla.org/en-US/docs/Web/CSS/color-scheme
         */
        'font-weight-medium': {
            value: string;
        };
        'font-weight-semibold': {
            value: string;
        };
        'font-weight-bold': {
            value: string;
        };
        'line-height-1': {
            value: string;
        };
        'line-height-2': {
            value: string;
        };
        'line-height-3': {
            value: string;
        };
        'line-height-4': {
            value: string;
        };
        'line-height-5': {
            value: string;
        };
        'line-height-6': {
            value: string;
        };
        'line-height-7': {
            value: string;
        };
    };
    zIndex: {
        'z-1': {
            value: string;
        };
        'z-2': {
            value: string;
        };
        'z-3': {
            value: string;
        };
        'z-4': {
            value: string;
        };
        'z-5': {
            value: string;
        };
        'z-6': {
            value: string;
        };
        'z-7': {
            value: string;
        };
        'z-8': {
            value: string;
        };
        'z-9': {
            value: string;
        };
        'z-10': {
            value: string;
        };
        'z-11': {
            value: string;
        };
        'z-12': {
            value: string;
        };
    };
};
//# sourceMappingURL=tokens.d.ts.map