'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var breakpoints = require('./token-groups/breakpoints.js');
var depth = require('./token-groups/depth.js');
var legacy = require('./token-groups/legacy.js');
var color_dark = require('./token-groups/color.dark.js');
var color_light = require('./token-groups/color.light.js');
var motion = require('./token-groups/motion.js');
var shape = require('./token-groups/shape.js');
var spacing = require('./token-groups/spacing.js');
var typography = require('./token-groups/typography.js');
var zIndex = require('./token-groups/zIndex.js');
var utilities = require('./utilities.js');

/**
 * Values to convert to CSS custom properties.
 * @example {background: '#000'} // --p-background: #000;
 */

var osColorSchemes = {
  light: 'light',
  dark: 'dark'
};
/**
 * Polaris color schemes and their associated color tokens.
 */

var colorSchemes = {
  light: color_light.colors,
  dark: color_dark.colors
};
var tokens = createTokens({
  breakpoints: utilities.tokensToRems(breakpoints.breakpoints),
  colorSchemes: colorSchemes,
  depth: depth.depth,
  legacyTokens: utilities.tokensToRems(legacy.legacy),
  motion: motion.motion,
  shape: utilities.tokensToRems(shape.shape),
  spacing: utilities.tokensToRems(spacing.spacing),
  typography: utilities.tokensToRems(typography.typography),
  zIndex: zIndex.zIndex
});
/**
 * Identity function that simply returns the provided tokens, but additionally
 * validates the input matches the `Tokens` type exactly and infers all members.
 */

function createTokens(tokens) {
  return tokens;
}

exports.osColorSchemes = osColorSchemes;
exports.tokens = tokens;
