import { Indexable } from './merge';
import { ActionSetInterface, Component, Group } from './types';
export declare function actionWrapper(action: any): any;
export declare function getVersion(): any;
/**
 * Returns full event name with prefix, group, subgroups and type formatted with separators
 * @internal
 * */
export declare function getEventNameSpace(group: string, eventName: string, component?: Component): string;
export declare function isValidOptionalNumber(value?: number): boolean;
export declare function isValidOptionalString(value?: string): boolean;
export declare function updateActionFromPayload<A extends Partial<ActionSetInterface>>(action: A, newProps: A): boolean;
export declare function getMergedProps<Prop extends Indexable>(props: Prop, newProps: Partial<Prop>): Prop;
export declare function forEachInEnum<E extends Indexable>(types: E, callback: (prop: string) => void): void;
export declare function findMatchInEnum<E extends Indexable>(types: E, lookup: string): string | undefined;
export declare const NonSnakeCaseGroup: Group[];
