import { ClientApplication } from '../../client';
import { ComplexDispatch, MetaAction } from '../types';
import { ActionSet } from '../ActionSet';
/**
 * Types
 */
/**
 * @public
 */
export declare enum Action {
    SHOW = "APP::SHARE::SHOW",
    CLOSE = "APP::SHARE::CLOSE"
}
/**
 * @public
 */
export interface TextPayload {
    text: string;
}
export interface UrlPayload {
    url: string;
}
export declare type InputPayload = TextPayload | UrlPayload;
/**
 * @public
 */
export interface OutputPayload {
    success: boolean;
    id?: string;
}
/**
 * Action
 */
/**
 * A set of actions for displaying a Share Sheet component
 * @public
 */
export declare class Share extends ActionSet implements ComplexDispatch<InputPayload> {
    constructor(app: ClientApplication);
    /**
     * @public
     */
    dispatch(action: Action.SHOW, payload: InputPayload): Share;
    dispatch(action: Action.CLOSE, payload: OutputPayload): Share;
    /**
     * @internal
     */
    private dispatchShareAction;
}
/**
 * @public
 */
export declare function create(app: ClientApplication): Share;
export declare type ShareAction = MetaAction;
export declare function show(): ShareAction;
export declare function close(payload: OutputPayload): ShareAction;
