import { AppLink, Payload as LinkPayload } from '../../Link/AppLink';
import { ClientApplication } from '../../../client';
import { ActionSetWithChildren } from '../../ActionSet';
import { ActionSetProps, Group, MetaAction } from '../../types';
export declare enum Action {
    UPDATE = "APP::MENU::NAVIGATION_MENU::UPDATE",
    LINK_UPDATE = "APP::MENU::NAVIGATION_MENU::LINK::UPDATE"
}
export interface Options {
    items?: AppLink[];
    active?: AppLink;
}
export interface Payload {
    readonly id?: string;
    items: LinkPayload[];
    active?: string;
}
export interface MenuAction extends MetaAction {
    readonly group: typeof Group.Menu;
    readonly type: Action;
    payload: Payload;
}
export declare type NavigationMenuAction = MenuAction | MetaAction;
export declare function update(payload: Payload): MenuAction;
export declare class NavigationMenu extends ActionSetWithChildren implements ActionSetProps<Options, Payload> {
    private items;
    private active?;
    private itemsOptions?;
    private activeOptions?;
    constructor(app: ClientApplication, options: Options);
    get options(): Options;
    get payload(): Payload;
    set(options: Partial<Options>, shouldUpdate?: boolean): this;
    dispatch(action: Action): this;
    private updateItem;
    private setItems;
}
export declare function create(app: ClientApplication, options: Options): NavigationMenu;
