import { ClientApplication } from '../../../client/index';
import { ActionSet } from '../../ActionSet';
import { ActionSetProps, Component, Group, MetaAction } from '../../types';
import { Action as RedirectType, AppPayload } from '../../Navigation/Redirect';
export declare enum Action {
    UPDATE = "UPDATE"
}
export interface Options {
    label: string;
    destination: string;
}
export interface InternalOptions extends Options {
    redirectType: RedirectType;
}
export interface Payload {
    readonly id: string;
    label: string;
    redirectType: RedirectType;
    destination: AppPayload;
}
export interface UpdateAction extends MetaAction {
    readonly group: typeof Group.Link;
    payload: Payload;
}
export declare function update(group: string, component: Component, updatePayload: Payload): UpdateAction;
export declare class AppLink extends ActionSet implements ActionSetProps<Options, Payload> {
    label: string;
    destination: string;
    constructor(app: ClientApplication, options: Options);
    get options(): InternalOptions;
    get payload(): Payload;
    set(options: Partial<Options>, shouldUpdate?: boolean): this;
    dispatch(action: Action): this;
}
export declare function create(app: ClientApplication, options: Options): AppLink;
