import { ClientApplication } from '../../client';
import { ActionSet } from '../ActionSet';
import { ActionSetProps, ClickAction, Component, MetaAction } from '../types';
export declare enum Action {
    CLICK = "CLICK",
    UPDATE = "UPDATE"
}
export declare enum Icon {
    Print = "print"
}
export declare enum Style {
    Danger = "danger"
}
export interface Presentation {
    icon?: Icon;
    style?: Style;
}
export interface Options extends Presentation {
    label: string;
    disabled?: boolean;
    loading?: boolean;
    plain?: boolean;
}
export interface Payload extends Options {
    readonly id: string;
}
export interface ClickPayload {
    readonly id: string;
    payload?: any;
}
export interface ButtonUpdateAction extends MetaAction {
    readonly group: string;
    payload: Payload;
}
export declare type ButtonAction = ButtonUpdateAction | ClickAction | MetaAction;
export declare function clickButton(group: string, component: Component, payload?: ClickPayload): ClickAction;
export declare function update(group: string, component: Component, props: Payload): ButtonUpdateAction;
export declare function isValidButtonProps(button: Payload): boolean;
export declare class Button extends ActionSet implements ActionSetProps<Options, Payload> {
    label: string;
    disabled: boolean;
    icon?: Icon;
    style?: Style;
    loading: boolean;
    plain: boolean;
    constructor(app: ClientApplication, options: Options);
    get options(): Options;
    get payload(): Payload;
    set(options: Partial<Options>, shouldUpdate?: boolean): this;
    dispatch(action: Action.UPDATE): ActionSet;
    dispatch(action: Action.CLICK, payload?: any): ActionSet;
}
export declare function create(app: ClientApplication, options: Options): Button;
