"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_TOAST_DURATION = void 0;
var react_1 = __importDefault(require("react"));
var actions_1 = require("@shopify/app-bridge/actions");
var context_1 = require("../../context");
exports.DEFAULT_TOAST_DURATION = 5000;
/**
 * Toast component
 *
 * @remarks
 * React component which wraps the Shopify App Bridge Toast action.
 *
 * @public
 */
var Toast = /** @class */ (function (_super) {
    __extends(Toast, _super);
    function Toast() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Toast.prototype.componentDidMount = function () {
        var app = this.context;
        var _a = this.props, error = _a.error, content = _a.content, _b = _a.duration, duration = _b === void 0 ? exports.DEFAULT_TOAST_DURATION : _b, onDismiss = _a.onDismiss, action = _a.action;
        this.toast = actions_1.Toast.create(app, {
            message: content,
            duration: duration,
            isError: error,
            action: (action === null || action === void 0 ? void 0 : action.content)
                ? {
                    content: action === null || action === void 0 ? void 0 : action.content,
                }
                : undefined,
        });
        if (action === null || action === void 0 ? void 0 : action.onAction) {
            this.toast.subscribe(actions_1.Toast.Action.ACTION, action === null || action === void 0 ? void 0 : action.onAction);
        }
        this.toast.subscribe(actions_1.Toast.Action.CLEAR, onDismiss);
        this.toast.dispatch(actions_1.Toast.Action.SHOW);
    };
    Toast.prototype.componentWillUnmount = function () {
        this.toast.unsubscribe();
    };
    Toast.prototype.render = function () {
        return null;
    };
    Toast.contextType = context_1.AppBridgeContext;
    return Toast;
}(react_1.default.PureComponent));
exports.default = Toast;
