import { Size } from '@shopify/app-bridge/actions/Modal';
import { ActionProps } from '../../types';
export interface Props {
    /** Whether the modal is open or not */
    open: boolean;
    /** The url that will be loaded as the content of the modal */
    src?: string;
    /** The content for the title of the modal */
    title?: string;
    /** Controls the size of the modal */
    size?: keyof typeof Size;
    /** Message to display inside modal */
    message?: string;
    /** Primary action */
    primaryAction?: ActionProps;
    /** Collection of secondary actions */
    secondaryActions?: ActionProps[];
    /** Callback when the modal is closed */
    onClose?(): void;
    /** Enable loading behaviour, when `true` bear in mind you will need to use `Modal Content` to dismiss the loading after the iframe page is fully loaded */
    loading?: boolean;
}
/**
 * Modal component
 *
 * @remarks
 * React component which wraps the Shopify App Bridge Modal action.
 *
 * @public
 */
declare function Modal(props: Props): null;
export default Modal;
