/// <reference types="node" resolution-mode="require"/>
import { relative, dirname, join, normalize, resolve, basename, extname, isAbsolute } from 'pathe';
import type { URL } from 'url';
export { join as joinPath, relative as relativePath, normalize as normalizePath, resolve as resolvePath, isAbsolute as isAbsolutePath, dirname, basename, extname, };
/**
 * Given an absolute filesystem path, it makes it relative to
 * the current working directory. This is useful when logging paths
 * to allow the users to click on the file and let the OS open it
 * in the editor of choice.
 *
 * @param path - Path to relativize.
 * @param dir - Current working directory.
 * @returns Relativized path.
 */
export declare function relativizePath(path: string, dir?: string): string;
/**
 * Given a module's import.meta.url it returns the directory containing the module.
 *
 * @param moduleURL - The value of import.meta.url in the context of the caller module.
 * @returns The path to the directory containing the caller module.
 */
export declare function moduleDirectory(moduleURL: string | URL): string;
/**
 * When running a script using `npm run`, something interesting happens. If the current
 * folder does not have a `package.json` or a `node_modules` folder, npm will traverse
 * the directory tree upwards until it finds one. Then it will run the script and set
 * `process.cwd()` to that folder, while the actual path is stored in the INIT_CWD
 * environment variable (see here: https://docs.npmjs.com/cli/v9/commands/npm-run-script#description).
 *
 * @returns The path to the current working directory.
 */
export declare function cwd(): string;
