import { JsonMap } from '../../private/common/json.js';
export declare const environmentsFilename = "shopify.environments.toml";
export interface Environments {
    [name: string]: JsonMap;
}
/**
 * Loads environments from a directory.
 * @param dir - The directory to load environments from.
 * @param opts - Options for loading environments, including:
 * - findUp: whether to search upwards for an environments file.
 * @returns The loaded environments.
 */
export declare function loadEnvironmentsFromDirectory(dir: string, opts?: {
    findUp: boolean;
}): Promise<Environments>;
