import React from 'react';
interface OnChangeOptions<T> {
    item: Item<T> | undefined;
    usedShortcut: boolean;
}
export interface SelectInputProps<T> {
    items: Item<T>[];
    onChange: ({ item, usedShortcut }: OnChangeOptions<T>) => void;
    enableShortcuts?: boolean;
    focus?: boolean;
    emptyMessage?: string;
    defaultValue?: Item<T>;
    highlightedTerm?: string;
    loading?: boolean;
    errorMessage?: string;
    hasMorePages?: boolean;
    morePagesMessage?: string;
    infoMessage?: string;
}
export interface Item<T> {
    label: string;
    value: T;
    key?: string;
    group?: string;
}
declare function SelectInput<T>({ items, onChange, enableShortcuts, focus, emptyMessage, defaultValue, highlightedTerm, loading, errorMessage, hasMorePages, morePagesMessage, infoMessage, }: React.PropsWithChildren<SelectInputProps<T>>): JSX.Element | null;
export { SelectInput };
