import { List } from '../List.js';
import { capitalize } from '../../../../../public/common/string.js';
import { Box, Text } from 'ink';
import React from 'react';
const InfoTable = ({ table }) => {
    const headers = Object.keys(table);
    const headerColumnWidth = Math.max(...headers.map((header) => header.length));
    return (React.createElement(Box, { flexDirection: "column" }, headers.map((header, index) => (React.createElement(Box, { key: index, marginBottom: index === headers.length - 1 ? 0 : 1 },
        header.length > 0 && (React.createElement(Box, { width: headerColumnWidth + 1 },
            React.createElement(Text, null,
                capitalize(header),
                ":"))),
        React.createElement(Box, { marginLeft: header.length > 0 ? 2 : 0, flexGrow: 1 },
            React.createElement(List, { margin: false, items: table[header] })))))));
};
export { InfoTable };
//# sourceMappingURL=InfoTable.js.map