import { collectLog, consoleLog, outputWhereAppropriate } from '../../public/node/output.js';
import { isUnitTest } from '../../public/node/context/local.js';
import { render as inkRender } from 'ink';
import treeKill from 'tree-kill';
import { EventEmitter } from 'events';
export function renderOnce(element, logLevel = 'info', logger = consoleLog) {
    const { output, unmount } = renderString(element);
    if (output) {
        if (isUnitTest())
            collectLog(logLevel, output);
        outputWhereAppropriate(logLevel, logger, output);
    }
    unmount();
}
export function render(element, options) {
    const { waitUntilExit } = inkRender(element, options);
    return waitUntilExit();
}
export class OutputStream extends EventEmitter {
    constructor(options) {
        super();
        this.write = (frame) => {
            this._lastFrame = frame;
        };
        this.lastFrame = () => {
            return this._lastFrame;
        };
        this.columns = options.columns;
    }
}
export const renderString = (element) => {
    const stdout = new OutputStream({ columns: process.stdout.columns });
    const stderr = new OutputStream({ columns: process.stderr.columns });
    const instance = inkRender(element, {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        stdout: stdout,
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        stderr: stderr,
        debug: true,
        exitOnCtrlC: false,
        patchConsole: false,
    });
    return {
        output: stdout.lastFrame(),
        unmount: instance.unmount,
    };
};
export function handleCtrlC(input, key) {
    if (input === 'c' && key.ctrl) {
        // Exceptions thrown in hooks aren't caught by our errorHandler.
        treeKill(process.pid, 'SIGINT');
    }
}
//# sourceMappingURL=ui.js.map