import { TextBlockProps } from '../TextBlock';
export interface SkeletonTextBlockProps extends Pick<TextBlockProps, 'size'> {
    /**
     * @private
     * Use to emphasize a word or a group of words.
     */
    emphasis?: 'bold';
    /**
     * Number of lines to display when no children are passed.
     *
     * @defaultValue 1
     */
    lines?: number;
}
/**
 * SkeletonTextBlock is used to provide a low fidelity representation of a block of text before it appears on the page.
 */
export declare const SkeletonTextBlock: "SkeletonTextBlock" & {
    readonly type?: "SkeletonTextBlock" | undefined;
    readonly props?: SkeletonTextBlockProps | undefined;
    readonly children?: true | undefined;
};
//# sourceMappingURL=SkeletonTextBlock.d.ts.map