export interface ChoiceProps {
    /**
     * A unique identifier for the choice.
     */
    id: string;
    /**
     * Whether the choice can be changed.
     */
    disabled?: boolean;
    /**
     * A label to use for the choice that will be used for buyers using
     * assistive technologies. When set, any `children` supplied to
     * this component are hidden from being seen for accessibility purposes
     * to prevent duplicate content from being read.
     */
    accessibilityLabel?: string;
}
/**
 * Options inside a `ChoiceList`.
 * The wrapping `ChoiceList` component will dictate if the choice renders as radio buttons or checkboxes.
 */
export declare const Choice: "Choice" & {
    readonly type?: "Choice" | undefined;
    readonly props?: ChoiceProps | undefined;
    readonly children?: true | undefined;
};
//# sourceMappingURL=Choice.d.ts.map