import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the current discount codes applied to the cart, and automatically re-renders
 * your component if discount codes are added or removed.
 */
function useDiscountCodes() {
  const {
    discountCodes
  } = useExtensionApi();
  return useSubscription(discountCodes);
}

/**
 * Returns the current discount allocations applied to the cart, and automatically re-renders
 * your component if discount allocations changed.
 */
function useDiscountAllocations() {
  const {
    discountAllocations
  } = useExtensionApi();
  return useSubscription(discountAllocations);
}

/**
 * Returns a function to add or remove discount codes.
 */
function useApplyDiscountCodeChange() {
  return useExtensionApi().applyDiscountCodeChange;
}

export { useApplyDiscountCodeChange, useDiscountAllocations, useDiscountCodes };
