import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the current line items for the checkout, and automatically re-renders
 * your component if line items are added, removed, or updated.
 */
function useCartLines() {
  const {
    lines
  } = useExtensionApi();
  return useSubscription(lines);
}

/**
 * Returns a function to mutate the `lines` property of checkout.
 */
function useApplyCartLinesChange() {
  return useExtensionApi().applyCartLinesChange;
}

export { useApplyCartLinesChange, useCartLines };
