import { ScopeNotGrantedError } from '../errors.mjs';
import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the account belonging to the customer.
 *
 * The value is a `Customer` if the customer has an account and is logged in,
 * `undefined` otherwise.
 */
function useCustomer() {
  const buyerIdentity = useExtensionApi().buyerIdentity;
  if (!buyerIdentity) {
    throw new ScopeNotGrantedError('Using buyer identity requires having personal customer data permissions granted to your app.');
  }
  return useSubscription(buyerIdentity.customer);
}
function useEmail() {
  const buyerIdentity = useExtensionApi().buyerIdentity;
  if (!buyerIdentity) {
    throw new ScopeNotGrantedError('Using buyer identity requires having personal customer data permissions granted to your app.');
  }
  return useSubscription(buyerIdentity.email);
}
function usePhone() {
  const buyerIdentity = useExtensionApi().buyerIdentity;
  if (!buyerIdentity) {
    throw new ScopeNotGrantedError('Using buyer identity requires having personal customer data permissions granted to your app.');
  }
  return useSubscription(buyerIdentity.phone);
}

export { useCustomer, useEmail, usePhone };
