import { useContext } from 'react';
import { CheckoutUIExtensionError } from '../errors.mjs';
import { ExtensionApiContext } from '../context.mjs';

/**
 * Returns the full API object that was passed in to your
 * extension when it was created.
 */
function useExtensionApi() {
  const api = useContext(ExtensionApiContext);
  if (api == null) {
    throw new CheckoutUIExtensionError('You can only call this hook when running as a UI extension.');
  }
  return api;
}

export { useExtensionApi };
