'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the current array of `metafields` applied to the checkout.
 * You can optionally filter the list.
 * @arg {MetafieldsFilters} - filter the list of returned metafields
 */
function useMetafields(filters) {
  const metaFields = subscription.useSubscription(api.useExtensionApi().metafields);
  return react.useMemo(() => {
    if (filters) {
      const {
        namespace,
        key
      } = filters;
      if (!namespace) {
        throw new errors.CheckoutUIExtensionError('You must pass in a namespace with a key');
      }
      const filteredResults = metaFields.filter(metafield => metafield.namespace === namespace && (!key || metafield.key === key));
      return filteredResults;
    }
    return metaFields;
  }, [filters, metaFields]);
}

/**
 * Returns a function to mutate the `metafields` property of the checkout.
 */
function useApplyMetafieldsChange() {
  return api.useExtensionApi().applyMetafieldChange;
}

exports.useApplyMetafieldsChange = useApplyMetafieldsChange;
exports.useMetafields = useMetafields;
