'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the proposed `attributes` applied to the checkout.
 */
function useAttributes() {
  return subscription.useSubscription(api.useExtensionApi().attributes);
}

/**
 * Returns a function to mutate the `attributes` property of the checkout.
 */
function useApplyAttributeChange() {
  return api.useExtensionApi().applyAttributeChange;
}

exports.useApplyAttributeChange = useApplyAttributeChange;
exports.useAttributes = useAttributes;
