import { ThemeExtensionSchema, ZodSchemaType } from './schemas.js';
import { GenericSpecification, ThemeExtension } from '../app/extensions.js';
import { schema } from '@shopify/cli-kit/node/schema';
export type ThemeConfigContents = schema.infer<typeof ThemeExtensionSchema>;
export interface ThemeExtensionSpec extends GenericSpecification {
    identifier: 'theme';
    supportedFlavors: [];
    registrationLimit: 1;
    gated: false;
    category: () => 'theme';
    partnersWebIdentifier: 'theme_app_extension';
    graphQLType: 'theme_app_extension';
    schema: ZodSchemaType<ThemeConfigContents>;
}
/**
 * Class that represents an instance of a local theme extension
 * Before creating this class we've validated that
 * the config toml file for the theme extension follow the ThemeExtensionSchema
 *
 * This class holds the public interface to interact with theme extensions
 */
export declare class ThemeExtensionInstance<TConfiguration extends ThemeConfigContents = ThemeConfigContents> implements ThemeExtension<TConfiguration> {
    localIdentifier: string;
    idEnvironmentVariableName: string;
    directory: string;
    configuration: TConfiguration;
    configurationPath: string;
    specification: ThemeExtensionSpec;
    outputBundlePath: string;
    get graphQLType(): string;
    get identifier(): "theme";
    get type(): "theme";
    get humanName(): string;
    get name(): string;
    get externalType(): string;
    constructor(options: {
        configuration: TConfiguration;
        configurationPath: string;
        directory: string;
        specification: ThemeExtensionSpec;
        outputBundlePath: string;
    });
    publishURL(options: {
        orgId: string;
        appId: string;
        extensionId?: string;
    }): Promise<string>;
    previewMessage(): import("@shopify/cli-kit/node/output").TokenizedString;
}
export declare function themeSpecForType(type: string): Promise<ThemeExtensionSpec | undefined>;
