import { generateSchemaService } from '../../../services/generate-schema.js';
import { functionFlags, inFunctionContext } from '../../../services/function/common.js';
import { Flags } from '@oclif/core';
import { globalFlags } from '@shopify/cli-kit/node/cli';
import Command from '@shopify/cli-kit/node/base-command';
import { outputInfo } from '@shopify/cli-kit/node/output';
export default class FetchSchema extends Command {
    async run() {
        const { flags, args } = await this.parse(FetchSchema);
        const apiKey = flags['api-key'];
        await inFunctionContext(this.config, flags.path, async (app, ourFunction) => {
            outputInfo(await generateSchemaService({ app, extension: ourFunction, apiKey }));
        });
    }
}
FetchSchema.description = 'Fetch the latest GraphQL schema for a Function.';
FetchSchema.flags = {
    ...globalFlags,
    ...functionFlags,
    'api-key': Flags.string({
        name: 'API key',
        description: 'The API key to fetch the schema with.',
        required: false,
        env: 'SHOPIFY_FLAG_APP_API_KEY',
    }),
};
//# sourceMappingURL=schema.js.map