import React from 'react';
import styles from './Menu.scss.js';
import { Message } from './components/Message/Message.js';
import { Popover } from '../../../Popover/Popover.js';
import { ActionList } from '../../../ActionList/ActionList.js';

function Menu(props) {
  const {
    actions,
    onOpen,
    onClose,
    open,
    activatorContent,
    message,
    colorScheme,
    accessibilityLabel
  } = props;
  const badgeProps = message && message.badge && {
    content: message.badge.content,
    status: message.badge.status
  };
  const messageMarkup = message && /*#__PURE__*/React.createElement(Message, {
    title: message.title,
    description: message.description,
    action: {
      onClick: message.action.onClick,
      content: message.action.content
    },
    link: {
      to: message.link.to,
      content: message.link.content
    },
    badge: badgeProps
  });
  const isFullHeight = Boolean(message);

  if (colorScheme && process.env.NODE_ENV === 'development') {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: The `colorScheme` prop on the `Menu` component has been deprecated. See the v10 migration guide for replacing dark color scheme styles. https://github.com/Shopify/polaris/blob/main/documentation/guides/migrating-from-v9-to-v10.md');
  }

  return /*#__PURE__*/React.createElement(Popover, {
    activator: /*#__PURE__*/React.createElement("div", {
      className: styles.ActivatorWrapper
    }, /*#__PURE__*/React.createElement("button", {
      type: "button",
      className: styles.Activator,
      onClick: onOpen,
      "aria-label": accessibilityLabel
    }, activatorContent)),
    active: open,
    onClose: onClose,
    fixed: true,
    fullHeight: isFullHeight,
    preferredAlignment: "right",
    colorScheme: colorScheme
  }, /*#__PURE__*/React.createElement(ActionList, {
    onActionAnyItem: onClose,
    sections: actions
  }), messageMarkup);
}

export { Menu };
