'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var Navigation = require('../../../../Navigation.scss.js');
var hooks = require('../../../../../../utilities/unique-id/hooks.js');
var Collapsible = require('../../../../../Collapsible/Collapsible.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function Secondary({
  id,
  children,
  expanded
}) {
  const uid = hooks.useUniqueId('SecondaryNavigation');
  return /*#__PURE__*/React__default["default"].createElement(Collapsible.Collapsible, {
    id: id || uid,
    open: expanded,
    transition: {
      duration: '0ms',
      timingFunction: 'linear'
    }
  }, /*#__PURE__*/React__default["default"].createElement("ul", {
    className: Navigation["default"].List
  }, children));
}

exports.Secondary = Secondary;
