'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var useIsMountedRef = require('../../../../utilities/use-is-mounted-ref.js');
var Loading$1 = require('./Loading.scss.js');
var hooks = require('../../../../utilities/i18n/hooks.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const STUCK_THRESHOLD = 99;
function Loading() {
  const i18n = hooks.useI18n();
  const isMountedRef = useIsMountedRef.useIsMountedRef();
  const [progress, setProgress] = React.useState(0);
  const [animating, setAnimating] = React.useState(false);
  React.useEffect(() => {
    if (progress >= STUCK_THRESHOLD || animating) {
      return;
    }

    requestAnimationFrame(() => {
      if (!isMountedRef.current) return;
      const step = Math.max((STUCK_THRESHOLD - progress) / 10, 1);
      setAnimating(true);
      setProgress(progress + step);
    });
  }, [progress, animating, isMountedRef]);
  const customStyles = {
    transform: `scaleX(${Math.floor(progress) / 100})`
  };
  return /*#__PURE__*/React__default["default"].createElement("div", {
    className: Loading$1["default"].Loading,
    "aria-valuenow": progress,
    "aria-valuemin": 0,
    "aria-valuemax": 100,
    role: "progressbar",
    "aria-label": i18n.translate('Polaris.Loading.label')
  }, /*#__PURE__*/React__default["default"].createElement("div", {
    className: Loading$1["default"].Level,
    style: customStyles,
    onTransitionEnd: () => setAnimating(false)
  }));
}

exports.Loading = Loading;
