import type { Exact } from './types';
import type { Tokens, TokenGroup } from './tokens';
import type { breakpoints as breakpointsTokenGroup } from './token-groups/breakpoints';
export declare function getUnit(value?: string): string | null;
export declare function toPx(value?: string): string | undefined;
export declare function toEm(value?: string, fontSize?: number): string | undefined;
export declare function toRem(value?: string): string | undefined;
export declare function tokensToRems<T extends Exact<TokenGroup, T>>(tokenGroup: T): T;
export declare function createVar(token: string): string;
/**
 * Allowed Polaris keyframes.
 *
 * Result: ['p-keyframes-fade-in', 'p-keyframes-spin', etc...]
 */
export declare function getKeyframeNames(motionTokenGroup: TokenGroup): (string | null)[];
/**
 * Allowed Polaris token custom properties.
 *
 * Result: ['--p-background', '--p-text', etc...]
 */
export declare function getCustomPropertyNames(tokens: Tokens): string[];
export declare type BreakpointsTokenGroup = typeof breakpointsTokenGroup;
export declare type BreakpointsTokenName = keyof BreakpointsTokenGroup;
/**
 * Alias extracted from each Polaris `breakpoints` token name.
 *
 * @example 'xs' | 'sm' | 'md' | 'lg' | 'xl'
 */
export declare type BreakpointsAlias = BreakpointsTokenName extends `${string}-${infer Alias}` ? Alias : never;
/**
 * Alias direction used for composing Polaris `breakpoints` utilities.
 */
export declare type BreakpointsAliasDirection = 'up' | 'down' | 'only';
/**
 * A collection of directional media conditions for a given Polaris `breakpoints` alias.
 */
export declare type BreakpointsAliasDirectionMediaConditions = {
    [AliasDirection in BreakpointsAliasDirection]: string;
};
/**
 * Media conditions for all Polaris `breakpoints` aliases.
 */
export declare type BreakpointsMediaConditions = {
    [TokenName in BreakpointsTokenName]: BreakpointsAliasDirectionMediaConditions;
};
export declare function getMediaConditions(breakpoints: BreakpointsTokenGroup): BreakpointsMediaConditions;
//# sourceMappingURL=utilities.d.ts.map