import type { ClientApplication } from '../../client';
declare type FetchOperation = (input: RequestInfo | URL, init?: RequestInit | undefined) => Promise<Response>;
export interface AuthenticatedFetchOptions {
    /**
     * The fetch function to perform the network call.
     */
    fetchOperation?: FetchOperation;
    /**
     * The URL to redirect to when the session token is invalid.
     * If not provided, `requestFailureReauthorizeUrlHeader` will be used.
     */
    reauthorizeUrl?: string;
    /**
     * The Header parameter.
     */
    requestFailureReauthorizeUrlHeader: string;
}
export declare function authenticatedFetch(app: ClientApplication, fetchOperationOrOptions?: FetchOperation | AuthenticatedFetchOptions | undefined): (uri: RequestInfo, options?: RequestInit) => Promise<Response>;
export {};
