import { FeaturesAvailable, PermissionType } from '../client/types';
import { MetaAction } from './types';
/**
 * Predicate to determine if an action is an App Bridge action.
 * @public
 */
export declare function isAppBridgeAction(action: any): action is MetaAction;
/**
 * Function used to determine if an action is in the Performance or WebVitals groups
 * @public
 */
export declare function isPerformanceOrWebVitalsAction({ type }: {
    type: string;
}): RegExpMatchArray | null;
/**
 * Predicate to determine if an action originated from an application.
 * @internal
 */
export declare function isFromApp(action: any): boolean;
/**
 * Returns the action type without the prefix and group
 * @internal
 */
export declare function getPermissionKey(type: string): string;
/**
 * Predicate to determine if an action is permitted
 * @internal
 */
export declare function isPermitted(features: FeaturesAvailable, { group, type }: MetaAction, permissionType: PermissionType): boolean;
/**
 * Predicate to determine if an event originated from an application.
 * @internal
 */
export declare function isAppMessage(event: any): boolean;
