import { ClientApplication } from '../../client/index';
import { ActionSet } from '../ActionSet';
import { Group, MetaAction, SimpleDispatch } from '../types';
/**
 * Pos action type enum
 * @remarks includes the action prefix and group
 *
 */
export declare enum Action {
    CLOSE = "APP::POS::CLOSE",
    LOCATION_UPDATE = "APP::POS::LOCATION::UPDATE",
    USER_UPDATE = "APP::POS::USER::UPDATE",
    DEVICE_UPDATE = "APP::POS::DEVICE::UPDATE"
}
export interface Location {
    id: number;
    active: boolean;
    name: string;
    locationType?: string;
    address1?: string;
    address2?: string;
    zip?: string;
    city?: string;
    province?: string;
    countryCode?: string;
    countryName?: string;
    phone?: string;
}
export interface User {
    id: number;
    firstName: string;
    lastName: string;
    email: string;
    accountOwner: boolean;
    userType: string;
}
export interface Device {
    name: string;
    serialNumber: string;
}
export interface CloseAction extends MetaAction {
    readonly group: typeof Group.Pos;
    readonly type: typeof Action.CLOSE;
}
export declare function close(): CloseAction;
export declare class Pos extends ActionSet implements SimpleDispatch {
    constructor(app: ClientApplication);
    dispatch(action: Action): this;
}
export declare function create(app: ClientApplication): Pos;
