import { ClientApplication } from '../../../client';
import { ActionSet } from '../../ActionSet';
import { ComplexDispatch, MetaAction } from '../../types';
export declare enum Action {
    PUSH = "APP::NAVIGATION::HISTORY::PUSH",
    REPLACE = "APP::NAVIGATION::HISTORY::REPLACE"
}
export interface Payload {
    id?: string;
    path: string;
}
export interface HistoryAction extends MetaAction {
    payload: Payload;
}
export declare function push(payload: Payload): HistoryAction;
export declare function replace(payload: Payload): HistoryAction;
export declare class History extends ActionSet implements ComplexDispatch<string> {
    constructor(app: ClientApplication);
    get payload(): {
        id: string;
    };
    dispatch(type: Action, path: string): this;
}
export declare function create(app: ClientApplication): History;
