import { ClientApplication } from '../../client';
import { ActionSet } from '../ActionSet';
import { ActionSetPayload, MetaAction } from '../types';
export declare enum Action {
    START = "APP::LOADING::START",
    STOP = "APP::LOADING::STOP"
}
export interface Payload {
    readonly id?: string;
}
export declare type LoadingAction = MetaAction;
export declare function start(payload?: Payload): LoadingAction;
export declare function stop(payload?: Payload): LoadingAction;
export declare class Loading extends ActionSet implements ActionSetPayload<Payload> {
    constructor(app: ClientApplication);
    get payload(): {
        id: string;
    };
    dispatch(action: Action): this;
}
export declare function create(app: ClientApplication): Loading;
