import { ClientApplication } from '../../client';
import { ActionSet } from '../ActionSet';
import { Group, MetaAction, ActionSetPayload } from '../types';
/**
 * Fullscreen action type enum
 * @remarks includes the action prefix and group
 *
 * @beta
 */
export declare enum Action {
    ENTER = "APP::FULLSCREEN::ENTER",
    EXIT = "APP::FULLSCREEN::EXIT"
}
export declare function enter(): MetaAction;
export declare function exit(): MetaAction;
/**
 * Fullscreen action payload interface
 * @beta
 */
export interface Payload {
    readonly id: string;
}
/**
 * Fullscreen action interface
 * @beta
 */
export interface FullscreenAction extends MetaAction {
    readonly group: typeof Group.Fullscreen;
    readonly type: Action;
    payload?: Payload;
}
/**
 * Fullscreen action set
 * @beta
 */
export declare class Fullscreen extends ActionSet implements ActionSetPayload<Payload> {
    /**
     * Returns a new instance of a Fullscreen action set
     * @param app the client application
     */
    constructor(app: ClientApplication);
    /**
     * Returns the action set payload
     */
    get payload(): {
        id: string;
    };
    /**
     * Dispatches a given action with the action set payload
     * @param action the action enum
     * @returns the action set instance
     */
    dispatch(action: Action): this;
}
/**
 * Returns a new instance of a Fullscreen action set
 * @param app the client application
 *
 * @beta
 */
export declare function create(app: ClientApplication): Fullscreen;
