import { ClientApplication } from '../../client';
import { ActionSet } from '../ActionSet';
import { ActionSetProps, Group, MetaAction } from '../types';
/**
 * Action for the Feedback Modal group
 * @public
 */
export declare enum Action {
    OPEN = "APP::FEEDBACK_MODAL::OPEN",
    CLOSE = "APP::FEEDBACK_MODAL::CLOSE"
}
/**
 * Payload for the Feedback Modal group
 * @public
 */
export interface Options {
    formId: number;
}
export interface OpenPayload extends Options {
    readonly id?: string;
}
export interface ClosePayload {
    readonly id?: string;
}
/**
 * FeedbackModal action interface
 * @internal
 */
export interface ActionBase extends MetaAction {
    readonly group: typeof Group.FeedbackModal;
}
export interface OpenAction extends ActionBase {
    readonly type: typeof Action.OPEN;
    readonly payload: OpenPayload;
}
export interface CloseAction extends ActionBase {
    readonly type: typeof Action.CLOSE;
    readonly payload: ClosePayload;
}
export declare function open(payload: OpenPayload): OpenAction;
export declare function close(payload: ClosePayload): CloseAction;
/**
 * FeedbackModal action set
 */
export declare class FeedbackModal extends ActionSet implements ActionSetProps<Options, OpenPayload> {
    options: Options;
    /**
     * Returns a new instance of a FeedbackModal action set
     * @param app the client application
     */
    constructor(app: ClientApplication, options: Options);
    /**
     * Returns the action set payload
     */
    get payload(): OpenPayload;
    set(options: Partial<Options>): this;
    /**
     * Dispatches a given action with the action set payload
     * @param action the action enum
     * @returns the action set instance
     */
    dispatch(action: Action): this;
}
/**
 * Returns a new instance of a FeedbackModal action set
 * @param app the client application
 */
export declare function create(app: ClientApplication, options: Options): FeedbackModal;
