import type { ClientApplication } from '@shopify/app-bridge';
/**
 * Automatically track changes to the document.body height and dispatch and action to update the modal size
 * @remarks This utility should only be used for an app that is meant to open inside a Modal
 * @param app App Bridge client application instance
 * @returns function to remove the auto-size tracker for the document.body
 *
 * @public
 */
export declare function setupModalAutoSizing(app: ClientApplication): Promise<() => void>;
/**
 * Sets up modal auto sizing, using a MutationObserver.
 *
 * @param app App Bridge client application instance
 * @param id Currently active modal instance ID
 *
 * @internal
 */
export declare function createMutationObserver(app: ClientApplication, id: string): MutationObserver | undefined;
