"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var context_1 = require("../../context");
var route_propagator_1 = require("./route-propagator");
/**
 * RoutePropagator component
 *
 * @remarks
 * React component which keeps the Shopify admin url in sync with the app url
 *
 * @public
 */
var RoutePropagator = /** @class */ (function (_super) {
    __extends(RoutePropagator, _super);
    function RoutePropagator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RoutePropagator.prototype.componentDidMount = function () {
        var location = this.props.location;
        route_propagator_1.updateHistory(this.context, location);
    };
    RoutePropagator.prototype.componentDidUpdate = function (_a) {
        var prevLocation = _a.location;
        var location = this.props.location;
        if (location !== prevLocation) {
            route_propagator_1.updateHistory(this.context, location);
        }
    };
    RoutePropagator.prototype.render = function () {
        return null;
    };
    RoutePropagator.contextType = context_1.AppBridgeContext;
    return RoutePropagator;
}(react_1.default.Component));
exports.default = RoutePropagator;
