import { Command, Interfaces } from '@oclif/core';
declare abstract class BaseCommand extends Command {
    static analyticsNameOverride(): string | undefined;
    catch(error: Error & {
        exitCode?: number | undefined;
    }): Promise<void>;
    protected init(): Promise<any>;
    protected exitWithTimestampWhenEnvVariablePresent(): void;
    protected parse<TFlags extends Interfaces.FlagOutput & {
        path?: string;
        verbose?: boolean;
    }, TGlobalFlags extends Interfaces.FlagOutput, TArgs extends Interfaces.OutputArgs>(options?: Interfaces.Input<TFlags, TGlobalFlags>, argv?: string[]): Promise<Interfaces.ParserOutput<TFlags, TGlobalFlags, TArgs>>;
    protected resultWithEnvironment<TFlags extends Interfaces.FlagOutput & {
        path?: string;
        verbose?: boolean;
    }, TGlobalFlags extends Interfaces.FlagOutput, TArgs extends Interfaces.OutputArgs>(originalResult: Interfaces.ParserOutput<TFlags, TGlobalFlags, TArgs>, options?: Interfaces.Input<TFlags, TGlobalFlags>, argv?: string[]): Promise<Interfaces.ParserOutput<TFlags, TGlobalFlags, TArgs>>;
    protected environmentsPath(rawFlags: {
        path?: string;
    }): Promise<string>;
    protected findUpForEnvironments(): boolean;
}
export declare function addFromParsedFlags(flags: {
    path?: string;
    verbose?: boolean;
}): Promise<void>;
export default BaseCommand;
