import { Alert } from './components/Alert.js';
import { renderOnce } from '../ui.js';
import { consoleLog, consoleWarn } from '../../../public/node/output.js';
import React from 'react';
const typeToLogLevel = {
    info: 'info',
    warning: 'warn',
    success: 'info',
};
const typeToLogger = {
    info: consoleLog,
    warning: consoleWarn,
    success: consoleLog,
};
export function alert({ type, headline, body, nextSteps, reference, link, customSections, orderedNextSteps = false, }) {
    renderOnce(React.createElement(Alert, { type: type, headline: headline, body: body, nextSteps: nextSteps, reference: reference, link: link, orderedNextSteps: orderedNextSteps, customSections: customSections }), typeToLogLevel[type], typeToLogger[type]);
}
//# sourceMappingURL=alert.js.map