/// <reference types="node" resolution-mode="require"/>
import { Logger, LogLevel } from '../../public/node/output.js';
import { ReactElement } from 'react';
import { Key, RenderOptions } from 'ink';
import { EventEmitter } from 'events';
export declare function renderOnce(element: JSX.Element, logLevel?: LogLevel, logger?: Logger): void;
export declare function render(element: JSX.Element, options?: RenderOptions): Promise<void>;
interface Instance {
    output: string | undefined;
    unmount: () => void;
}
export declare class OutputStream extends EventEmitter {
    columns: number;
    private _lastFrame?;
    constructor(options: {
        columns: number;
    });
    write: (frame: string) => void;
    lastFrame: () => string | undefined;
}
export declare const renderString: (element: ReactElement) => Instance;
export declare function handleCtrlC(input: string, key: Key): void;
export {};
