import { outputContent, outputDebug } from '@shopify/cli-kit/node/output';
import Conf from 'conf';
export { Conf };
let _instance;
/**
 * CLIKIT Store.
 *
 * @returns CLIKitStore.
 */
function cliKitStore() {
    if (!_instance) {
        _instance = new Conf({ projectName: 'shopify-cli-kit' });
    }
    return _instance;
}
/**
 * Get session.
 *
 * @returns Session.
 */
export function getSession(config = cliKitStore()) {
    outputDebug(outputContent `Getting session store...`);
    return config.get('sessionStore');
}
/**
 * Set session.
 *
 * @param session - Session.
 */
export function setSession(session, config = cliKitStore()) {
    outputDebug(outputContent `Setting session store...`);
    config.set('sessionStore', session);
}
/**
 * Remove session.
 */
export function removeSession(config = cliKitStore()) {
    outputDebug(outputContent `Removing session store...`);
    config.delete('sessionStore');
}
//# sourceMappingURL=conf-store.js.map