# TextField

Use a text field to get text input from a customer.

## Props
optional = ?

| Name | Type | Description |
| --- | --- | --- |
| id? | <code>string</code> | A unique identifier for the field. When no `id` is set, a globally unique value will be used instead. |
| icon? | <code><a href="#iconsource">IconSource</a> &#124; {source: <a href="#iconsource">IconSource</a>, position?: "start" &#124; "end"}</code> | An icon to render at the start or end of the field. It will render at the start by default. |
| name? | <code>string</code> | An identifier for the field that is unique within the nearest containing `Form` component. |
| label | <code>string</code> | Content to use as the field label. This value is also used as the placeholder when the field is empty. |
| prefix? | <code>string</code> | Text content to render before the value. |
| suffix? | <code>string</code> | Text content to render at the end of the text field. |
| accessory? | <code>string &#124; RemoteFragment</code> | Any content to render at the end of the text field. Commonly used to display an icon that opens a tooltip providing more information about the field. |
| accessibilityDescription? | <code>string</code> | A detailed description for screen readers. |
| value? | <code>string &#124; number &#124; undefined</code> | The current value for the field. If omitted, the field will be empty. You should update this value in response to the `onChange` callback. |
| controlledValue? | <code>string &#124; number &#124; undefined</code> | In rare cases, like the PhoneField component, we completely control state. In those cases, there is never a difference between the `value` prop of the field and the current value in the field, and so this component never considers the field to have changed. Use the `controlledValue` prop to provide the value that should be shown to the buyer in those circumstances, but where the `value` prop will continue to be used as the comparison value to determine whether the field has changed. This value will usually be set to the last committed, unformatted value for the controlled input. |
| type? | <code>"text" &#124; "email" &#124; "number" &#124; "telephone"</code> | The content type a buyer will enter into the field. This type is used to provide semantic value to the field and, where possible, will provide the buyer with a better editing experience for the content type.<br /><br />Note that the type property does not change the way the text field’s value will be provided in `onChange` or `onInput`; a text field with a type of `'number'` will still provide the exact user entry, as a string, to those callbacks. The type also does not perform any form of automatic validation. If you want to perform validation, use the `error` property. |
| required? | <code>boolean</code> | Whether the field needs a value. This requirement adds semantic value to the field, but it will not cause an error to appear automatically. If you want to present an error when this field is empty, you can do so with the `error` prop. |
| error? | <code>string</code> | Indicate an error to the user. The field will be given a specific stylistic treatment to communicate problems that have to be resolved immediately. |
| multiline? | <code>boolean &#124; number</code> | Whether the field supports multiple lines of input. Set a `number` to define the default lines of the input. |
| autocomplete? | <code><a href="#autocomplete">Autocomplete</a> &#124; boolean</code> | A hint as to the intended content of the field.<br /><br />When set to `true`, this property indicates that the field should support autofill, but you do not have any more semantic information on the intended contents.<br /><br />When set to `false`, you are indicating that this field contains sensitive information, or contents that are never saved, like one-time codes.<br /><br />Alternatively, you can provide an `Autocomplete` object, which describes the specific data you would like to be entered into this field during autofill. |
| disabled? | <code>boolean</code> | Whether the field can be modified. |
| readonly? | <code>boolean</code> | Whether the field is read-only. |
| maxLength? | <code>number</code> | Specifies the maximum number of characters allowed. |
| onFocus? | <code>() => void</code> | Callback when input is focused. |
| onBlur? | <code>() => void</code> | Callback when focus is removed. |
| onChange? | <code>(value: string &#124; number &#124; undefined) => void</code> | Callback when the buyer has **finished editing** a field. Unlike `onChange` callbacks you may be familiar with from Polaris or other React component libraries, this callback is **not** run on every change to the input. Text fields are “partially controlled” components, which means that while the buyer edits the field, its state is controlled by the component. Once the buyer has signalled that they have finished editing the field (typically, by blurring the field), `onChange` is called if the input actually changed from the most recent `value` property. At that point, you are expected to store this “committed value” in state, and reflect it in the text field’s `value` property.<br /><br />This state management model is important given how UI Extensions are rendered. UI Extension components run on a separate thread from the UI, so they can’t respond to input synchronously. A pattern popularized by [controlled React components](https://reactjs.org/docs/forms.html#controlled-components) is to have the component be the source of truth for the input `value`, and update the `value` on every user input. The delay in responding to events from a UI extension is only a few milliseconds, but attempting to strictly store state with this delay can cause issues if a user types quickly, or if the buyer is using a lower-powered device. Having the UI thread take ownership for “in progress” input, and only synchronizing when the user is finished with a field, avoids this risk.<br /><br />It can still sometimes be useful to be notified when the user makes any input in the field. If you need this capability, you can use the `onInput` prop. However, never use that property to create tightly controlled state for the `value`.<br /><br />This callback is called with the current value of the field. If the value of a field is the same as the current `value` prop provided to the field, the `onChange` callback will not be run. |
| onInput? | <code>(value: string &#124; number &#124; undefined) => void</code> | Callback when the user makes any changes in the field. As noted in the documentation for `onChange`, you **must not** use this to update `state` — use the `onChange` callback for that purpose. Use the `onInput` prop when you need to do something as soon as the buyer makes a change, like clearing validation errors that apply to the field as soon as the user begins making the necessary adjustments.<br /><br />This callback is called with the current value of the field. |<a name="Autocomplete"></a>

### Autocomplete

A descriptor for selecting the data a field would like to receive during
autocomplete. This attribute is modeled off of a limited set of the autocomplete
values supported in browsers.

| Name | Type | Description |
| --- | --- | --- |
| group? | <code>"shipping" &#124; "billing" &#124; "location"</code> | The contact information “group” the autocomplete data should be sourced from. |
| field | <code>"name" &#124; "honorific-prefix" &#124; "given-name" &#124; "additional-name" &#124; "family-name" &#124; "honorific-suffix" &#124; "nickname" &#124; "username" &#124; "new-password" &#124; "current-password" &#124; "one-time-code" &#124; "organization-title" &#124; "organization" &#124; "street-address" &#124; "address-line1" &#124; "address-line2" &#124; "address-line3" &#124; "address-level4" &#124; "address-level3" &#124; "address-level2" &#124; "address-level1" &#124; "country" &#124; "country-name" &#124; "postal-code" &#124; "credit-card-name" &#124; "credit-card-given-name" &#124; "credit-card-additional-name" &#124; "credit-card-family-name" &#124; "credit-card-number" &#124; "credit-card-expiry" &#124; "credit-card-expiry-month" &#124; "credit-card-expiry-year" &#124; "credit-card-security-code" &#124; "credit-card-type" &#124; "transaction-currency" &#124; "transaction-amount" &#124; "language" &#124; "birthday" &#124; "birthday-day" &#124; "birthday-month" &#124; "birthday-year" &#124; "sex" &#124; "url" &#124; "photo" &#124; "telephone" &#124; "telephone-country-code" &#124; "telephone-national" &#124; "telephone-area-code" &#124; "telephone-local" &#124; "telephone-local-prefix" &#124; "telephone-local-suffix" &#124; "telephone-extension" &#124; "email" &#124; "instant-message" &#124; "home telephone" &#124; "home telephone-country-code" &#124; "home telephone-national" &#124; "home telephone-area-code" &#124; "home telephone-local" &#124; "home telephone-local-prefix" &#124; "home telephone-local-suffix" &#124; "home telephone-extension" &#124; "home email" &#124; "home instant-message" &#124; "work telephone" &#124; "work telephone-country-code" &#124; "work telephone-national" &#124; "work telephone-area-code" &#124; "work telephone-local" &#124; "work telephone-local-prefix" &#124; "work telephone-local-suffix" &#124; "work telephone-extension" &#124; "work email" &#124; "work instant-message" &#124; "mobile telephone" &#124; "mobile telephone-country-code" &#124; "mobile telephone-national" &#124; "mobile telephone-area-code" &#124; "mobile telephone-local" &#124; "mobile telephone-local-prefix" &#124; "mobile telephone-local-suffix" &#124; "mobile telephone-extension" &#124; "mobile email" &#124; "mobile instant-message" &#124; "fax telephone" &#124; "fax telephone-country-code" &#124; "fax telephone-national" &#124; "fax telephone-area-code" &#124; "fax telephone-local" &#124; "fax telephone-local-prefix" &#124; "fax telephone-local-suffix" &#124; "fax telephone-extension" &#124; "fax email" &#124; "fax instant-message" &#124; "pager telephone" &#124; "pager telephone-country-code" &#124; "pager telephone-national" &#124; "pager telephone-area-code" &#124; "pager telephone-local" &#124; "pager telephone-local-prefix" &#124; "pager telephone-local-suffix" &#124; "pager telephone-extension" &#124; "pager email" &#124; "pager instant-message"</code> | The type of data that should be inserted into a field supporting autocomplete. |
<a name="IconSource"></a>

### IconSource

<code>"arrowLeft" &#124; "arrowRight" &#124; "arrowUp" &#124; "arrowUpRight" &#124; "arrowDown" &#124; "bag" &#124; "calendar" &#124; "camera" &#124; "caretDown" &#124; "cart" &#124; "checkmark" &#124; "chevronDown" &#124; "chevronUp" &#124; "chevronRight" &#124; "chevronLeft" &#124; "close" &#124; "critical" &#124; "discount" &#124; "delivered" &#124; "delivery" &#124; "disabled" &#124; "email" &#124; "errorFill" &#124; "geolocation" &#124; "grid" &#124; "hamburger" &#124; "horizontalDots" &#124; "info" &#124; "infoFill" &#124; "list" &#124; "lock" &#124; "magnify" &#124; "map" &#124; "marker" &#124; "minus" &#124; "mobile" &#124; "note" &#124; "pen" &#124; "verticalDots" &#124; "plus" &#124; "questionFill" &#124; "reorder" &#124; "store" &#124; "success" &#124; "truck" &#124; "warning" &#124; "warningFill" &#124; "giftFill" &#124; "external" &#124; "profile"</code>