import { createRemoteComponent } from '@remote-ui/core';

/**
 * Modals are a special type of overlay that shift focus towards a specific action/set of information
 * before the main flow can proceed.
 * They must be specified inside the `overlay` prop of an activator component (`Button`, `Link` or `Pressable`).
 *
 * The library takes care of applying the WAI-ARIA Dialog pattern automatically for the activator
 * and the modal content.
 */
const Modal = createRemoteComponent('Modal');

export { Modal };
