import type { StandardApi, RenderExtensionPoint } from '@shopify/checkout-ui-extensions';
interface MetafieldsFilters {
    namespace: string;
    key?: string;
}
/**
 * Returns the current array of `metafields` applied to the checkout.
 * You can optionally filter the list.
 * @arg {MetafieldsFilters} - filter the list of returned metafields
 */
export declare function useMetafields<ID extends RenderExtensionPoint = RenderExtensionPoint>(filters?: MetafieldsFilters): import("@shopify/checkout-ui-extensions").Metafield[];
/**
 * Returns a function to mutate the `metafields` property of the checkout.
 */
export declare function useApplyMetafieldsChange<ID extends RenderExtensionPoint = RenderExtensionPoint>(): StandardApi<ID>['applyMetafieldChange'];
export {};
//# sourceMappingURL=metafields.d.ts.map