import type { RenderExtensionPoint, Interceptor } from '@shopify/checkout-ui-extensions';
/**
 * Returns the `buyerJourney` details on buyer progression in checkout.
 */
export declare function useBuyerJourney<ID extends RenderExtensionPoint = RenderExtensionPoint>(): {
    intercept(interceptor: Interceptor): Promise<() => void>;
    completed: import("@remote-ui/async-subscription").StatefulRemoteSubscribable<boolean>;
};
/**
 * Returns true if the buyer completed submitting their order.
 *
 * For example, when viewing the order status page after submitting payment, the buyer will have completed their order.
 */
export declare function useBuyerJourneyCompleted<ID extends RenderExtensionPoint = RenderExtensionPoint>(): boolean;
/**
 * Returns a function to intercept and block navigation in checkout.
 */
export declare function useBuyerJourneyIntercept<ID extends RenderExtensionPoint = RenderExtensionPoint>(interceptor: Interceptor): void;
//# sourceMappingURL=buyer-journey.d.ts.map