import { render as render$1 } from '@remote-ui/react';
import { extend } from '@shopify/checkout-ui-extensions';
import { ExtensionApiContext } from './context.mjs';
import { jsx } from 'react/jsx-runtime';

function render(extensionPoint, render) {
  // TypeScript can’t infer the type of the callback because it’s a big union
  // type. To get around it, we’ll just fake like we are rendering the
  // Checkout::Dynamic::Render extension, since all render extensions have the same general
  // shape (`RenderExtension`).
  return extend(extensionPoint, (root, api) => {
    return new Promise((resolve, reject) => {
      try {
        render$1( /*#__PURE__*/jsx(ExtensionApiContext.Provider, {
          value: api,
          children: render(api)
        }), root, () => {
          resolve();
        });
      } catch (error) {
        // Workaround for https://github.com/Shopify/ui-extensions/issues/325
        // eslint-disable-next-line no-console
        console.error(error);
        reject(error);
      }
    });
  });
}

export { render };
