import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the current gift cards applied to the cart, and automatically re-renders
 * your component if gift cards are added or removed.
 */
function useAppliedGiftCards() {
  const {
    appliedGiftCards
  } = useExtensionApi();
  return useSubscription(appliedGiftCards);
}

/**
 * Returns a function to add or remove gift cards.
 */
function useApplyGiftCardChange() {
  return useExtensionApi().applyGiftCardChange;
}

export { useAppliedGiftCards, useApplyGiftCardChange };
