import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the currency of the checkout, and automatically re-renders
 * your component if the currency changes.
 */
function useCurrency() {
  const {
    localization
  } = useExtensionApi();
  return useSubscription(localization.currency);
}

export { useCurrency };
